## voice on pubmsg script v1.1 by aerosoul@IRCNet#playaz 
##
## this script will give voice to users who say something on the
## channel and devoice them after idle time.
##
## you will have a overlook of who
## idles and who is active on big channels which don't have
## much ops
##
## - add voice on pubmsg for #channel : .chanset #channel +av.pubmsg
##   remove with .chanset #channel -av.pubmsg
## - users with flag +1 (av_novoiceflag) won't be voiced
## - add devoice on idle: .chanset #channel +av.devoice
## - users with flag +g won't be devoiced
##
## devoice procs inspired by mc.idledemode.tcl
##

set av_novoiceflag "1"
set av_nodevoiceflag "g"
set av_dtime 23
set av_partylog 0


## respond to "thank you bot" automessages on voice?
set av_respond 1

## text to answer 
set av_rtext "*huh?*"

## text to react to
set av_keys {
"danke*botname"
"thanx*botname"
}

#####################################################

set av_delay [expr 5 + [rand 18]] 

if {$numversion < "1050000"} {
 putlog "you need eggdrop version >1.5 for autovoice on pubmsg script to work"
 return 1
}
setudef flag av.pubmsg
setudef flag av.devoice

proc av_main {nik uhost hand chan text} { 
 global av_delay av_novoiceflag av_respond av_rtext av_keys
 set av_delay [expr 5 + [rand 18]] 
 if {![string match *av_devoice* [timers]]} {timer [expr 3 + [rand 5]] av_devoice}
 set chan [string tolower $chan] 

 if {$av_respond == 1} {
  foreach rkey $av_keys {
   if {[string match [string tolower $rkey] [string tolower $text]]} {
	putchan $chan $av_rtext
   }
  }
 }

 if {[av_fcheck $chan] == 0} {return 0}
  if {[matchattr $hand $av_novoiceflag] || [matchattr $hand |$av_novoiceflag $chan]} { 
	return 0 
  } 
  if {![isop $nik $chan] && ![isvoice $nik $chan]} { 
	utimer $av_delay [split "av_doit $chan $nik"] 
  }
} 

proc av_doit {vchan vnick} { 
global av_delay
 if {![isop $vnick $vchan] && ![isvoice $vnick $vchan]} { 
 	pushmode $vchan +v $vnick 
 } 
 set av_delay [expr 5 + [rand 18]] 
} 

proc av_devoice {} {
global av_dtime av_nodevoiceflag av_partylog
if {![string match *av_devoice* [timers]]} {timer [expr 1 + [rand 3]] av_devoice}
 foreach chan [channels] {
  set av_deoplist ""
  if {[av_dcheck $chan] == 0} {continue}
  foreach user [chanlist $chan] {
   set hand [nick2hand $user]
   if {[matchattr $hand $av_nodevoiceflag] || [matchattr $hand |$av_nodevoiceflag $chan]} {
	continue
   }
   if {([getchanidle $user $chan] > $av_dtime) && [isvoice $user $chan] && ![isop $user $chan]} {
	pushmode $chan -v $user
	set av_deoplist "$av_deoplist $user"
   }
  }
  if {$av_partylog == 1} {
   set count 0
   foreach u $av_deoplist {
	set count [expr $count + 1]
   }
   if {$count == 0} {continue}
   putlog "-\[ av.pubmsg \]- devoicing users in $chan : $av_deoplist ( $count users )"
  }
 }
}

if {![string match *av_devoice* [timers]]} {timer [expr 3 + [rand 5]] av_devoice}

proc av_fcheck {chan} {
 foreach info [channel info $chan] {
  if {[string tolower [string range $info 1 e]] == "av.pubmsg"} {
   if {[string index $info 0] == "-"} {return 0} {return 1}
  }
 };return 0
}

proc av_dcheck {chan} {
 foreach info [channel info $chan] {
  if {[string tolower [string range $info 1 e]] == "av.devoice"} {
   if {[string index $info 0] == "-"} {return 0} {return 1}
  }
 };return 0
}

set autovoice_chans ""
foreach chan [channels] {
 if {[av_fcheck $chan] == 1} {
	set autovoice_chans "$autovoice_chans $chan"
 }
}

bind pubm - * av_main
putlog "-\[ voice on pubmsg script v1.1 by aerosoul active on: $autovoice_chans \]-"
